/* SenaSend View-Only App — Scripts */
/* Do not change the brand colors, logo usage, or typography — match the waitlist UI. */

function showToast(message) {
    var existing = document.querySelector('.toast');
    if (existing) existing.remove();

    var toast = document.createElement('div');
    toast.className = 'toast';
    toast.textContent = message || 'This is a demo feature';
    document.body.appendChild(toast);

    setTimeout(function() { toast.classList.add('show'); }, 10);
    setTimeout(function() {
        toast.classList.remove('show');
        setTimeout(function() { toast.remove(); }, 300);
    }, 3000);
}

function showModal(title, message, type) {
    var existing = document.querySelector('.sena-modal-overlay');
    if (existing) existing.remove();

    var iconMap = {
        info: '<svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="#1F6FEB" stroke-width="2"><circle cx="12" cy="12" r="10"/><line x1="12" y1="16" x2="12" y2="12"/><line x1="12" y1="8" x2="12.01" y2="8"/></svg>',
        success: '<svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="2"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>',
        warning: '<svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="#E0A832" stroke-width="2"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>'
    };

    var overlay = document.createElement('div');
    overlay.className = 'sena-modal-overlay';
    overlay.innerHTML =
        '<div class="sena-modal">' +
            '<div class="sena-modal-icon">' + (iconMap[type] || iconMap.info) + '</div>' +
            '<h3 class="sena-modal-title">' + (title || 'Demo Feature') + '</h3>' +
            '<p class="sena-modal-message">' + (message || 'This feature is not active in the demo.') + '</p>' +
            '<button class="btn btn-primary sena-modal-btn" onclick="closeModal()">Got it</button>' +
        '</div>';

    document.body.appendChild(overlay);
    setTimeout(function() { overlay.classList.add('show'); }, 10);

    overlay.addEventListener('click', function(e) {
        if (e.target === overlay) closeModal();
    });
}

function closeModal() {
    var overlay = document.querySelector('.sena-modal-overlay');
    if (overlay) {
        overlay.classList.remove('show');
        setTimeout(function() { overlay.remove(); }, 200);
    }
}

function demoAction(e) {
    if (e) e.preventDefault();
    showModal('Demo Feature', 'This action is not available in the demo version. It will be fully functional in the live application.', 'info');
}

function toggleSidebar() {
    var sidebar = document.getElementById('sidebar');
    var overlay = document.querySelector('.sidebar-overlay');
    if (sidebar) {
        sidebar.classList.toggle('open');
    }
    if (overlay) {
        overlay.classList.toggle('show');
    }
}

function toggleProfileDropdown() {
    var dropdown = document.getElementById('profileDropdown');
    var btn = document.getElementById('profileBtn');
    if (dropdown && btn) {
        dropdown.classList.toggle('show');
        btn.classList.toggle('active');
    }
}

document.addEventListener('DOMContentLoaded', function() {
    var demoBtns = document.querySelectorAll('[data-demo]');
    demoBtns.forEach(function(btn) {
        btn.addEventListener('click', function(e) {
            demoAction(e);
        });
    });

    document.addEventListener('click', function(e) {
        var dropdown = document.getElementById('profileDropdown');
        var btn = document.getElementById('profileBtn');
        if (dropdown && btn && !btn.contains(e.target) && !dropdown.contains(e.target)) {
            dropdown.classList.remove('show');
            btn.classList.remove('active');
        }
    });

    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') closeModal();
    });
});
