<?php $pageTitle = 'Convert'; $currentPage = 'convert'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Convert</h1>
                <p>Exchange between your KES and NGN wallets</p>
            </div>

            <div class="convert-layout">
                <div class="convert-form-wrap">
                    <div class="card">
                        <div class="form-group">
                            <label class="form-label">From</label>
                            <div class="convert-wallet-row">
                                <select class="form-select" id="fromCurrency" onchange="updateConversion()">
                                    <option value="KES">KES — Kenyan Shilling</option>
                                    <option value="NGN">NGN — Nigerian Naira</option>
                                </select>
                                <div class="convert-wallet-bal">Balance: KES 125,400.00</div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">Amount</label>
                            <input type="text" class="form-input convert-amount-input" id="convertAmount" placeholder="0.00" value="10,000" oninput="updateConversion()">
                        </div>

                        <div class="fx-swap">
                            <button class="fx-swap-btn" onclick="swapCurrencies()" title="Swap currencies">&#8645;</button>
                        </div>

                        <div class="form-group">
                            <label class="form-label">To</label>
                            <div class="convert-wallet-row">
                                <select class="form-select" id="toCurrency" onchange="updateConversion()">
                                    <option value="NGN">NGN — Nigerian Naira</option>
                                    <option value="KES">KES — Kenyan Shilling</option>
                                </select>
                                <div class="convert-wallet-bal">Balance: NGN 842,600.00</div>
                            </div>
                        </div>

                        <div class="fx-preview">
                            <div class="fx-preview-label">You will receive</div>
                            <div class="fx-preview-amount" id="previewAmount">NGN 34,200.00</div>
                            <div class="fx-preview-rate" id="previewRate">1 KES = 3.42 NGN</div>
                        </div>

                        <button class="btn btn-primary btn-full" onclick="showConvertConfirm()">Convert Now</button>
                    </div>
                </div>

                <div class="convert-details-wrap">
                    <div class="card">
                        <h3 class="card-title">Conversion Details</h3>
                        <div class="detail-rows">
                            <div class="detail-row">
                                <span class="detail-label">Exchange Rate</span>
                                <span class="detail-value" id="detailRate">1 KES = 3.42 NGN</span>
                            </div>
                            <div class="detail-row">
                                <span class="detail-label">Amount to Convert</span>
                                <span class="detail-value" id="detailAmount">KES 10,000.00</span>
                            </div>
                            <div class="detail-row">
                                <span class="detail-label">Conversion Fee</span>
                                <span class="detail-value detail-value-muted">KES 50.00</span>
                            </div>
                            <div class="detail-row">
                                <span class="detail-label">Processing Fee</span>
                                <span class="detail-value detail-value-muted">Free</span>
                            </div>
                            <div class="detail-divider"></div>
                            <div class="detail-row detail-row-total">
                                <span class="detail-label">You Receive</span>
                                <span class="detail-value detail-value-success" id="detailReceive">NGN 34,029.00</span>
                            </div>
                        </div>
                    </div>

                    <div class="card convert-info-card">
                        <div class="convert-info-icon">&#9432;</div>
                        <p>Rates are refreshed periodically. Final rate is locked at the time of confirmation.</p>
                    </div>
                </div>
            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
function swapCurrencies() {
    var from = document.getElementById('fromCurrency');
    var to = document.getElementById('toCurrency');
    var fromVal = from.value;
    var toVal = to.value;
    from.value = toVal;
    to.value = fromVal;
    updateConversion();
}

function getConversionData() {
    var from = document.getElementById('fromCurrency').value;
    var to = document.getElementById('toCurrency').value;
    var amountStr = document.getElementById('convertAmount').value.replace(/,/g, '');
    var amount = parseFloat(amountStr) || 0;
    var rate = (from === 'KES' && to === 'NGN') ? 3.42 : (from === 'NGN' && to === 'KES') ? 0.29 : 1;
    var fee = amount * 0.005;
    var converted = (amount - fee) * rate;
    return { from: from, to: to, amount: amount, rate: rate, fee: fee, converted: converted };
}

function fmt(n) {
    return n.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2});
}

function updateConversion() {
    var d = getConversionData();
    var fromBal = d.from === 'KES' ? 'KES 125,400.00' : 'NGN 842,600.00';
    var toBal = d.to === 'KES' ? 'KES 125,400.00' : 'NGN 842,600.00';

    document.querySelector('#fromCurrency').closest('.convert-wallet-row').querySelector('.convert-wallet-bal').textContent = 'Balance: ' + fromBal;
    document.querySelector('#toCurrency').closest('.convert-wallet-row').querySelector('.convert-wallet-bal').textContent = 'Balance: ' + toBal;

    document.getElementById('previewAmount').textContent = d.to + ' ' + fmt(d.converted);
    document.getElementById('previewRate').textContent = '1 ' + d.from + ' = ' + d.rate.toFixed(2) + ' ' + d.to;
    document.getElementById('detailRate').textContent = '1 ' + d.from + ' = ' + d.rate.toFixed(2) + ' ' + d.to;
    document.getElementById('detailAmount').textContent = d.from + ' ' + fmt(d.amount);
    document.getElementById('detailReceive').textContent = d.to + ' ' + fmt(d.converted);
}

function showConvertConfirm() {
    var d = getConversionData();
    var existing = document.querySelector('.sena-modal-overlay');
    if (existing) existing.remove();

    var overlay = document.createElement('div');
    overlay.className = 'sena-modal-overlay';
    overlay.innerHTML =
        '<div class="sena-modal sena-modal-wide">' +
            '<h3 class="sena-modal-title">Confirm Conversion</h3>' +
            '<p class="sena-modal-subtitle">Please review the details below before confirming.</p>' +
            '<div class="confirm-detail-rows">' +
                '<div class="confirm-detail-row">' +
                    '<span class="confirm-detail-label">From</span>' +
                    '<span class="confirm-detail-value">' + d.from + ' ' + fmt(d.amount) + '</span>' +
                '</div>' +
                '<div class="confirm-detail-row">' +
                    '<span class="confirm-detail-label">To</span>' +
                    '<span class="confirm-detail-value">' + d.to + ' Wallet</span>' +
                '</div>' +
                '<div class="confirm-detail-row">' +
                    '<span class="confirm-detail-label">Exchange Rate</span>' +
                    '<span class="confirm-detail-value">1 ' + d.from + ' = ' + d.rate.toFixed(2) + ' ' + d.to + '</span>' +
                '</div>' +
                '<div class="confirm-detail-row">' +
                    '<span class="confirm-detail-label">Conversion Fee</span>' +
                    '<span class="confirm-detail-value">' + d.from + ' ' + fmt(d.fee) + '</span>' +
                '</div>' +
                '<div class="confirm-detail-divider"></div>' +
                '<div class="confirm-detail-row confirm-detail-row-total">' +
                    '<span class="confirm-detail-label">You Receive</span>' +
                    '<span class="confirm-detail-value confirm-detail-value-success">' + d.to + ' ' + fmt(d.converted) + '</span>' +
                '</div>' +
            '</div>' +
            '<div class="sena-modal-actions">' +
                '<button class="btn btn-outline sena-modal-btn" onclick="closeModal()">Cancel</button>' +
                '<button class="btn btn-primary sena-modal-btn" onclick="confirmConvert()">Confirm Conversion</button>' +
            '</div>' +
        '</div>';

    document.body.appendChild(overlay);
    setTimeout(function() { overlay.classList.add('show'); }, 10);
    overlay.addEventListener('click', function(e) {
        if (e.target === overlay) closeModal();
    });
}

function confirmConvert() {
    closeModal();
    setTimeout(function() {
        showModal('Conversion Successful', 'Your funds have been converted successfully. This is a demo — no real transaction was processed.', 'success');
    }, 250);
}
</script>
