<?php $pageTitle = 'Dashboard'; $currentPage = 'dashboard'; $userTier = isset($_GET['tier']) ? (int)$_GET['tier'] : 1; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Dashboard</h1>
                <p>Overview of your SenaSend account</p>
            </div>

            <div class="wallet-grid">
                <div class="wallet-card">
                    <div class="wallet-flag">🇰🇪</div>
                    <div class="wallet-currency">KES Wallet</div>
                    <div class="wallet-balance">KES 125,400.00</div>
                    <div class="wallet-locked">Locked: KES 10,000.00</div>
                    <div class="wallet-actions wallet-actions-desktop">
                        <a href="transfer.php" class="btn btn-sm btn-primary">Send</a>
                    </div>
                </div>
                <div class="wallet-card">
                    <div class="wallet-flag">🇳🇬</div>
                    <div class="wallet-currency">NGN Wallet</div>
                    <div class="wallet-balance">NGN 842,600.00</div>
                    <div class="wallet-locked">Locked: NGN 50,000.00</div>
                    <div class="wallet-actions wallet-actions-desktop">
                        <a href="transfer.php" class="btn btn-sm btn-primary">Send</a>
                    </div>
                </div>
            </div>

            <div class="quick-actions">
                <a href="transfer.php" class="quick-action-btn">
                    <span class="quick-action-icon">
                        <svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="7" y1="17" x2="17" y2="7"/><polyline points="7 7 17 7 17 17"/></svg>
                    </span>
                    Send
                </a>
                <a href="add-money.php" class="quick-action-btn">
                    <span class="quick-action-icon">
                        <svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="12" y1="5" x2="12" y2="19"/><line x1="5" y1="12" x2="19" y2="12"/></svg>
                    </span>
                    Add Money
                </a>
                <a href="convert.php" class="quick-action-btn">
                    <span class="quick-action-icon">
                        <svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="17 1 21 5 17 9"/><path d="M3 11V9a4 4 0 014-4h14"/><polyline points="7 23 3 19 7 15"/><path d="M21 13v2a4 4 0 01-4 4H3"/></svg>
                    </span>
                    Convert
                </a>
                <a href="withdraw.php" class="quick-action-btn">
                    <span class="quick-action-icon">
                        <svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="12" y1="19" x2="12" y2="5"/><polyline points="5 12 12 5 19 12"/></svg>
                    </span>
                    Withdraw
                </a>
            </div>

            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Recent Transactions</h2>
                    <a href="transactions.php" class="btn btn-sm btn-outline">View All</a>
                </div>
                <div class="table-wrap">
                    <table>
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Currency</th>
                                <th>Status</th>
                                <th>Reference</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Feb 23, 2026</td>
                                <td>Send</td>
                                <td>- 15,000.00</td>
                                <td>KES</td>
                                <td><span class="badge badge-success">Completed</span></td>
                                <td>TXN-00481</td>
                            </tr>
                            <tr>
                                <td>Feb 22, 2026</td>
                                <td>Deposit</td>
                                <td>+ 50,000.00</td>
                                <td>NGN</td>
                                <td><span class="badge badge-success">Completed</span></td>
                                <td>TXN-00480</td>
                            </tr>
                            <tr>
                                <td>Feb 21, 2026</td>
                                <td>Conversion</td>
                                <td>+ 34,200.00</td>
                                <td>NGN</td>
                                <td><span class="badge badge-success">Completed</span></td>
                                <td>TXN-00479</td>
                            </tr>
                            <tr>
                                <td>Feb 20, 2026</td>
                                <td>Withdrawal</td>
                                <td>- 8,500.00</td>
                                <td>KES</td>
                                <td><span class="badge badge-pending">Pending</span></td>
                                <td>TXN-00478</td>
                            </tr>
                            <tr>
                                <td>Feb 19, 2026</td>
                                <td>Send</td>
                                <td>- 120,000.00</td>
                                <td>NGN</td>
                                <td><span class="badge badge-failed">Failed</span></td>
                                <td>TXN-00477</td>
                            </tr>
                            <tr>
                                <td>Feb 18, 2026</td>
                                <td>Deposit</td>
                                <td>+ 25,000.00</td>
                                <td>KES</td>
                                <td><span class="badge badge-success">Completed</span></td>
                                <td>TXN-00476</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>
