<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Buy Goods — Till Number</p>
            </div>

            <div class="mpesa-container">

                <div class="ke-change-method">
                    <a href="transfer-kenya-buygoods.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to amount
                    </a>
                </div>

                <div class="mpesa-card">
                    <label class="form-label">Till Number</label>
                    <div class="mpesa-phone-row">
                        <div class="mpesa-country-pill" style="padding:0 14px;">
                            <span class="mpesa-pill-code">TILL</span>
                        </div>
                        <input type="tel" class="mpesa-phone-input" id="tillInput" placeholder="e.g. 123456" maxlength="10" oninput="onTillInput(this)" style="letter-spacing:0.06em;">
                    </div>
                    <div class="mpesa-phone-hint" id="tillHint"><span class="mpesa-hint-default">Enter the merchant till number.</span></div>
                </div>

                <button class="btn btn-primary ke-proceed-btn" id="btnProceed" disabled onclick="proceedBuyGoods()" style="margin-top:28px;">Proceed</button>

                <div class="country-select-back" style="padding-top:22px;">
                    <a href="transfer-kenya.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Change method
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<div class="sena-toast" id="proceedToast">
    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
    <span>Proceeding...</span>
</div>

<script>
function onTillInput(input) {
    input.value = input.value.replace(/[^0-9]/g, '');
    var digits = input.value;
    var valid = digits.length >= 5 && digits.length <= 10;
    document.getElementById('btnProceed').disabled = !valid;
    var hint = document.getElementById('tillHint');
    if (digits.length === 0) {
        hint.innerHTML = '<span class="mpesa-hint-default">Enter the merchant till number.</span>';
    } else if (valid) {
        hint.innerHTML = '<span class="mpesa-hint-valid">Valid till number</span>';
    } else {
        hint.innerHTML = '<span class="mpesa-hint-default">Enter the merchant till number.</span>';
    }
}

function proceedBuyGoods() {
    var toast = document.getElementById('proceedToast');
    toast.classList.add('show');
    setTimeout(function() { toast.classList.remove('show'); }, 2500);
}
</script>
