<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Enter till number</p>
            </div>

            <div class="mpesa-container">

                <div class="ke-change-method">
                    <a href="transfer-kenya-buygoods-amount.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to amount
                    </a>
                </div>

                <div class="mpesa-card">
                    <label class="form-label">Merchant till number</label>
                    <div class="till-input-row">
                        <div class="till-icon-pill">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="var(--accent)" stroke-width="1.8"><path d="M6 2L3 6v14a2 2 0 002 2h14a2 2 0 002-2V6l-3-4z"/><line x1="3" y1="6" x2="21" y2="6"/><path d="M16 10a4 4 0 01-8 0"/></svg>
                        </div>
                        <input type="tel" class="mpesa-phone-input" id="tillInput" placeholder="123456" maxlength="10" oninput="onTillInput(this)" autofocus>
                    </div>
                    <div class="mpesa-phone-hint" id="tillHint"><span class="mpesa-hint-default">Enter the merchant's Buy Goods till number.</span></div>
                </div>

                <button class="btn btn-primary ke-proceed-btn" id="btnProceed" disabled onclick="proceedToVerify()" style="margin-top:28px;">Proceed</button>

                <div class="country-select-back" style="padding-top:22px;">
                    <a href="transfer-kenya.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Change method
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
function onTillInput(input) {
    input.value = input.value.replace(/[^0-9]/g, '');
    var digits = input.value;
    var valid = digits.length >= 4 && digits.length <= 10;
    document.getElementById('btnProceed').disabled = !valid;
    var hint = document.getElementById('tillHint');
    if (digits.length === 0) {
        hint.innerHTML = '<span class="mpesa-hint-default">Enter the merchant\'s Buy Goods till number.</span>';
    } else if (valid) {
        hint.innerHTML = '<span class="mpesa-hint-valid">Valid till number</span>';
    } else if (digits.length < 4) {
        hint.innerHTML = '<span class="mpesa-hint-default">Till number must be at least 4 digits.</span>';
    } else {
        hint.innerHTML = '<span class="mpesa-hint-error">Till number is too long</span>';
    }
}

function proceedToVerify() {
    sessionStorage.setItem('buygoods_till', document.getElementById('tillInput').value);
    window.location.href = 'transfer-kenya-buygoods-verify.php';
}
</script>
