<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Verifying merchant</p>
            </div>

            <div class="mpesa-container">

                <div class="verify-card mpesa-card">

                    <div class="verify-number-display">
                        <span class="verify-flag">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="var(--accent)" stroke-width="1.8"><path d="M6 2L3 6v14a2 2 0 002 2h14a2 2 0 002-2V6l-3-4z"/><line x1="3" y1="6" x2="21" y2="6"/><path d="M16 10a4 4 0 01-8 0"/></svg>
                        </span>
                        <span class="verify-number" id="tillDisplay">Till 123456</span>
                    </div>

                    <div class="verify-state" id="stateLoading">
                        <div class="verify-spinner"></div>
                        <p class="verify-status-text">Verifying merchant details&hellip;</p>
                    </div>

                    <div class="verify-state" id="stateSuccess" style="display:none;">
                        <div class="verify-icon verify-icon-success">
                            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
                        </div>
                        <p class="verify-status-text verify-text-success">Merchant verified</p>
                        <div class="verify-recipient-details">
                            <span class="verify-recipient-name" id="verifiedName">Naivas Supermarket</span>
                            <span class="verify-recipient-num" id="verifiedTill">Till 123456</span>
                            <span class="verify-pill-verified">Verified</span>
                        </div>
                    </div>

                    <div class="verify-state" id="stateFail" style="display:none;">
                        <div class="verify-icon verify-icon-fail">
                            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="var(--warning)" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><line x1="12" y1="8" x2="12" y2="13"/><circle cx="12" cy="16" r="0.5" fill="var(--warning)"/></svg>
                        </div>
                        <p class="verify-status-text verify-text-fail">We couldn't verify this till number</p>
                        <p class="verify-fallback-hint">You can continue by entering the business name.</p>
                        <div class="verify-fallback-input-wrap">
                            <label class="form-label">Business name</label>
                            <input type="text" class="verify-fallback-input" id="fallbackName" placeholder="Enter business name" oninput="onFallbackInput()">
                        </div>
                    </div>

                </div>

                <div class="verify-actions" id="verifyActions" style="display:none;">
                    <button class="btn btn-primary ke-proceed-btn" id="btnContinue" onclick="continueToReview()">Continue</button>
                    <button class="btn btn-outline verify-retry-btn" id="btnRetry" style="display:none;" onclick="retryVerification()">Try again</button>
                </div>

                <div class="country-select-back" style="padding-top:22px;">
                    <a href="transfer-kenya-buygoods-till.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to till number
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
var testMode = new URLSearchParams(window.location.search).get('test') || 'success';
var storedTill = sessionStorage.getItem('buygoods_till') || '123456';

document.getElementById('tillDisplay').textContent = 'Till ' + storedTill;
document.getElementById('verifiedTill').textContent = 'Till ' + storedTill;

setTimeout(function() {
    document.getElementById('stateLoading').style.display = 'none';

    if (testMode === 'fail') {
        document.getElementById('stateFail').style.display = 'flex';
        document.getElementById('btnRetry').style.display = 'block';
        document.getElementById('btnContinue').disabled = true;
    } else {
        document.getElementById('stateSuccess').style.display = 'flex';
        document.getElementById('btnContinue').disabled = false;
        sessionStorage.setItem('buygoods_business_name', 'Naivas Supermarket');
        sessionStorage.setItem('buygoods_verified', '1');
    }
    document.getElementById('verifyActions').style.display = 'flex';
}, 1600);

function onFallbackInput() {
    var val = document.getElementById('fallbackName').value.trim();
    document.getElementById('btnContinue').disabled = val.length < 2;
}

function continueToReview() {
    if (testMode === 'fail') {
        var name = document.getElementById('fallbackName').value.trim();
        sessionStorage.setItem('buygoods_business_name', name);
        sessionStorage.setItem('buygoods_verified', '0');
    }
    window.location.href = 'transfer-kenya-buygoods-review.php';
}

function retryVerification() {
    document.getElementById('stateFail').style.display = 'none';
    document.getElementById('verifyActions').style.display = 'none';
    document.getElementById('stateLoading').style.display = 'flex';
    document.getElementById('btnRetry').style.display = 'none';

    setTimeout(function() {
        document.getElementById('stateLoading').style.display = 'none';
        if (testMode === 'fail') {
            document.getElementById('stateFail').style.display = 'flex';
            document.getElementById('btnRetry').style.display = 'block';
            document.getElementById('btnContinue').disabled = true;
            onFallbackInput();
        } else {
            document.getElementById('stateSuccess').style.display = 'flex';
            document.getElementById('btnContinue').disabled = false;
        }
        document.getElementById('verifyActions').style.display = 'flex';
    }, 1600);
}
</script>
