<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Sending transfer</p>
            </div>

            <div class="mpesa-container">

                <div class="processing-card mpesa-card">

                    <div class="processing-spinner-wrap">
                        <div class="processing-spinner">
                            <svg width="56" height="56" viewBox="0 0 56 56" fill="none">
                                <circle cx="28" cy="28" r="24" stroke="rgba(255,255,255,0.06)" stroke-width="4"/>
                                <circle cx="28" cy="28" r="24" stroke="url(#processingGrad)" stroke-width="4" stroke-linecap="round" stroke-dasharray="100 51"/>
                                <defs>
                                    <linearGradient id="processingGrad" x1="0" y1="0" x2="56" y2="56">
                                        <stop offset="0%" stop-color="#1F6FEB"/>
                                        <stop offset="100%" stop-color="#2DCC9F"/>
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                    </div>

                    <h2 class="processing-title">Sending transfer&hellip;</h2>
                    <p class="processing-subtitle">Please do not close this window.</p>

                    <div class="processing-progress">
                        <div class="processing-bar">
                            <div class="processing-bar-fill" id="progressFill"></div>
                        </div>
                    </div>

                    <div class="processing-details">
                        <span class="processing-detail-label" id="processingStep">Initiating transfer</span>
                    </div>

                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
var steps = [
    { text: 'Initiating transfer', pct: 15 },
    { text: 'Validating recipient', pct: 40 },
    { text: 'Processing payment', pct: 70 },
    { text: 'Confirming transaction', pct: 95 }
];

var stepEl = document.getElementById('processingStep');
var fillEl = document.getElementById('progressFill');
var current = 0;

fillEl.style.width = '0%';

function nextStep() {
    if (current < steps.length) {
        stepEl.textContent = steps[current].text;
        fillEl.style.width = steps[current].pct + '%';
        current++;
        setTimeout(nextStep, 650);
    } else {
        fillEl.style.width = '100%';
        setTimeout(function() {
            window.location.href = 'transfer-kenya-mpesa-result.php?status=success';
        }, 400);
    }
}

setTimeout(nextStep, 300);
</script>
