<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Send money via M-PESA</p>
            </div>

            <div class="mpesa-container">

                <div class="ke-change-method">
                    <a href="transfer-kenya-mpesa.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to amount
                    </a>
                </div>

                <div class="mpesa-card">
                    <label class="form-label">Recipient mobile number</label>
                    <div class="mpesa-phone-row">
                        <div class="mpesa-country-pill">
                            <span class="mpesa-pill-flag">🇰🇪</span>
                            <span class="mpesa-pill-code">+254</span>
                        </div>
                        <input type="tel" class="mpesa-phone-input" id="phoneInput" placeholder="712 345 678" maxlength="12" oninput="onPhoneInput(this)" autofocus>
                        <button class="mpesa-contacts-btn" onclick="openSavedRecipients()" title="Saved recipients">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M17 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M23 21v-2a4 4 0 00-3-3.87"/><path d="M16 3.13a4 4 0 010 7.75"/></svg>
                        </button>
                    </div>
                    <div class="mpesa-phone-hint" id="phoneHint"><span class="mpesa-hint-default">Enter a valid Kenyan mobile number.</span></div>
                </div>

                <button class="btn btn-primary ke-proceed-btn" id="btnProceed" disabled onclick="proceedMpesa()" style="margin-top:28px;">Proceed</button>

                <div class="country-select-back" style="padding-top:22px;">
                    <a href="transfer-kenya.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Change method
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<div class="sena-modal-overlay" id="recipientsModal">
    <div class="sena-modal mpesa-recipients-modal">
        <div class="mpesa-modal-header">
            <h3 class="sena-modal-title">Saved recipients</h3>
            <button class="mpesa-modal-close" onclick="closeRecipients()">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/></svg>
            </button>
        </div>
        <div class="mpesa-search-wrap">
            <svg class="mpesa-search-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="11" cy="11" r="8"/><line x1="21" y1="21" x2="16.65" y2="16.65"/></svg>
            <input type="text" class="mpesa-search-input" id="recipientSearch" placeholder="Search name or number" oninput="filterRecipients()">
        </div>
        <div class="mpesa-recipient-list" id="recipientList"></div>
    </div>
</div>

<div class="sena-toast" id="proceedToast">
    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
    <span>Proceeding...</span>
</div>

<script>
var savedRecipients = [
    { name: 'Wanjiku M.', phone: '712345678', masked: '7** *** 678' },
    { name: 'Adebayo O.', phone: '723456214', masked: '7** *** 214' },
    { name: 'Chinedu O.', phone: '734567990', masked: '7** *** 990' },
    { name: 'Amina H.', phone: '745678111', masked: '7** *** 111' },
    { name: 'Demo Recipient', phone: '756789222', masked: '7** *** 222' },
    { name: 'Merchant Till', phone: '767890333', masked: '7** *** 333' }
];

function normalizePhone(val) {
    var digits = val.replace(/[^0-9]/g, '');
    if (digits.length >= 10 && digits.charAt(0) === '0') {
        digits = digits.substring(1);
    }
    if (digits.length >= 12 && digits.substring(0, 3) === '254') {
        digits = digits.substring(3);
    }
    return digits;
}

function onPhoneInput(input) {
    input.value = input.value.replace(/[^0-9 ]/g, '');
    var digits = normalizePhone(input.value);
    var valid = digits.length === 9;
    document.getElementById('btnProceed').disabled = !valid;
    var hint = document.getElementById('phoneHint');
    if (digits.length === 0) {
        hint.innerHTML = '<span class="mpesa-hint-default">Enter a valid Kenyan mobile number.</span>';
    } else if (valid) {
        hint.innerHTML = '<span class="mpesa-hint-valid">Valid mobile number</span>';
    } else if (digits.length > 9) {
        hint.innerHTML = '<span class="mpesa-hint-error">Number is too long</span>';
    } else {
        hint.innerHTML = '<span class="mpesa-hint-default">Enter a valid Kenyan mobile number.</span>';
    }
}

function openSavedRecipients() {
    renderRecipients(savedRecipients);
    document.getElementById('recipientSearch').value = '';
    var modal = document.getElementById('recipientsModal');
    modal.style.display = 'flex';
    setTimeout(function() { modal.classList.add('show'); }, 10);
}

function closeRecipients() {
    var modal = document.getElementById('recipientsModal');
    modal.classList.remove('show');
    setTimeout(function() { modal.style.display = 'none'; }, 250);
}

function renderRecipients(list) {
    var html = '';
    for (var i = 0; i < list.length; i++) {
        var r = list[i];
        var initials = r.name.split(' ').map(function(w) { return w.charAt(0); }).join('').substring(0, 2).toUpperCase();
        html += '<button class="mpesa-recipient-item" onclick="pickRecipient(\'' + r.phone + '\')">' +
            '<span class="mpesa-recipient-avatar">' + initials + '</span>' +
            '<span class="mpesa-recipient-info">' +
                '<span class="mpesa-recipient-name">' + r.name + '</span>' +
                '<span class="mpesa-recipient-number">' + r.masked + '</span>' +
            '</span>' +
        '</button>';
    }
    if (list.length === 0) {
        html = '<div class="mpesa-recipient-empty">No recipients found</div>';
    }
    document.getElementById('recipientList').innerHTML = html;
}

function filterRecipients() {
    var q = document.getElementById('recipientSearch').value.toLowerCase();
    var filtered = savedRecipients.filter(function(r) {
        return r.name.toLowerCase().indexOf(q) !== -1 || r.phone.indexOf(q) !== -1 || r.masked.indexOf(q) !== -1;
    });
    renderRecipients(filtered);
}

function pickRecipient(phone) {
    var input = document.getElementById('phoneInput');
    input.value = phone;
    onPhoneInput(input);
    closeRecipients();
}

function proceedMpesa() {
    var digits = normalizePhone(document.getElementById('phoneInput').value);
    sessionStorage.setItem('mpesa_phone', digits);
    window.location.href = 'transfer-kenya-mpesa-verify.php';
}

document.getElementById('recipientsModal').addEventListener('click', function(e) {
    if (e.target === this) closeRecipients();
});

document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') closeRecipients();
});

document.getElementById('phoneInput').focus();
</script>
