<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="result-container">

                <div class="result-card mpesa-card" id="resultSuccess" style="display:none;">
                    <div class="result-icon result-icon-success">
                        <svg width="52" height="52" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="1.8"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
                    </div>
                    <h2 class="result-title result-title-success">Transfer sent</h2>
                    <p class="result-reassurance">Your transfer was completed successfully.</p>

                    <div class="result-details">
                        <div class="result-row">
                            <span class="result-label">Reference ID</span>
                            <span class="result-value result-ref-wrap">
                                <span class="result-ref" id="refId">SN-20260224-7X9K2</span>
                                <button class="result-copy-btn" onclick="copyRef()" title="Copy reference ID">
                                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="9" y="9" width="13" height="13" rx="2"/><path d="M5 15H4a2 2 0 01-2-2V4a2 2 0 012-2h9a2 2 0 012 2v1"/></svg>
                                </button>
                            </span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Recipient</span>
                            <span class="result-value" id="resultRecipient">Wanjiku M.</span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Amount</span>
                            <span class="result-value result-amount" id="resultAmount">KSh 5,000.00</span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Date &amp; time</span>
                            <span class="result-value" id="resultDate">24 Feb 2026, 14:32</span>
                        </div>
                    </div>

                    <div class="result-actions">
                        <a href="transfer-country.php" class="btn btn-primary ke-proceed-btn">Make another transfer</a>
                        <a href="transactions.php" class="btn btn-outline verify-retry-btn">View transactions</a>
                    </div>
                </div>

                <div class="result-card mpesa-card" id="resultFailed" style="display:none;">
                    <div class="result-icon result-icon-fail">
                        <svg width="52" height="52" viewBox="0 0 24 24" fill="none" stroke="var(--error)" stroke-width="1.8"><circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/></svg>
                    </div>
                    <h2 class="result-title result-title-fail">Transfer failed</h2>
                    <p class="result-fail-message">Something went wrong. Please try again.</p>

                    <div class="result-actions">
                        <a href="transfer-kenya-mpesa.php" class="btn btn-primary ke-proceed-btn">Try again</a>
                        <a href="dashboard.php" class="btn btn-outline verify-retry-btn">Back to dashboard</a>
                    </div>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<div class="sena-toast" id="copyToast">
    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
    <span>Reference ID copied</span>
</div>

<script>
var status = new URLSearchParams(window.location.search).get('status') || 'success';
var recipientName = sessionStorage.getItem('mpesa_recipient_name') || 'Wanjiku M.';
var amount = sessionStorage.getItem('mpesa_amount') || '5000';

function formatAmount(raw) {
    var num = parseFloat(raw) || 5000;
    return 'KSh ' + num.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
}

function generateRef() {
    var chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
    var r = '';
    for (var i = 0; i < 5; i++) r += chars.charAt(Math.floor(Math.random() * chars.length));
    var d = new Date();
    var ds = d.getFullYear().toString() + String(d.getMonth()+1).padStart(2,'0') + String(d.getDate()).padStart(2,'0');
    return 'SN-' + ds + '-' + r;
}

function formatDate() {
    var d = new Date();
    var months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
    var hr = d.getHours();
    var mn = String(d.getMinutes()).padStart(2,'0');
    return d.getDate() + ' ' + months[d.getMonth()] + ' ' + d.getFullYear() + ', ' + String(hr).padStart(2,'0') + ':' + mn;
}

function copyRef() {
    var ref = document.getElementById('refId').textContent;
    if (navigator.clipboard) {
        navigator.clipboard.writeText(ref);
    } else {
        var ta = document.createElement('textarea');
        ta.value = ref;
        ta.style.position = 'fixed';
        ta.style.opacity = '0';
        document.body.appendChild(ta);
        ta.select();
        document.execCommand('copy');
        document.body.removeChild(ta);
    }
    var toast = document.getElementById('copyToast');
    toast.classList.add('show');
    setTimeout(function() { toast.classList.remove('show'); }, 2200);
}

if (status === 'failed') {
    document.getElementById('resultFailed').style.display = 'flex';
} else {
    document.getElementById('resultSuccess').style.display = 'flex';
    document.getElementById('refId').textContent = generateRef();
    document.getElementById('resultRecipient').textContent = recipientName;
    document.getElementById('resultAmount').textContent = formatAmount(amount);
    document.getElementById('resultDate').textContent = formatDate();
}
</script>
