<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Review your transfer</p>
            </div>

            <div class="mpesa-container">

                <div class="review-card mpesa-card">

                    <h3 class="review-title">Transfer Review</h3>

                    <div class="review-rows">
                        <div class="review-row">
                            <span class="review-label">Method</span>
                            <span class="review-value">M-PESA (Send Money)</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Amount</span>
                            <span class="review-value review-amount" id="reviewAmount">KSh 5,000.00</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Recipient number</span>
                            <span class="review-value" id="reviewNumber">+254 712 345 678</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Recipient name</span>
                            <span class="review-value" id="reviewName">
                                <span id="nameText">Wanjiku M.</span>
                                <span class="verify-pill-verified verify-pill-sm" id="verifiedBadge">Verified</span>
                            </span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Fees</span>
                            <span class="review-value review-fees">KSh 35.00</span>
                        </div>
                        <div class="review-divider review-divider-total"></div>
                        <div class="review-row review-row-total">
                            <span class="review-label">Total debit</span>
                            <span class="review-value review-total" id="reviewTotal">KSh 5,035.00</span>
                        </div>
                    </div>

                </div>

                <div class="review-actions">
                    <button class="btn btn-primary ke-proceed-btn" onclick="sendTransfer()">Send transfer</button>
                    <button class="btn btn-outline verify-retry-btn" onclick="editDetails()">Edit details</button>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
var recipientName = sessionStorage.getItem('mpesa_recipient_name') || 'Wanjiku M.';
var recipientPhone = sessionStorage.getItem('mpesa_phone') || '712345678';
var amount = sessionStorage.getItem('mpesa_amount') || '5000';
var verified = sessionStorage.getItem('mpesa_verified') === '1';

function formatPhone(raw) {
    var d = raw.replace(/[^0-9]/g, '');
    if (d.length === 9) return '+254 ' + d.substring(0,3) + ' ' + d.substring(3,6) + ' ' + d.substring(6);
    return '+254 ' + d;
}

function formatAmount(raw) {
    var num = parseFloat(raw) || 5000;
    return 'KSh ' + num.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
}

document.getElementById('nameText').textContent = recipientName;
document.getElementById('reviewNumber').textContent = formatPhone(recipientPhone);
document.getElementById('reviewAmount').textContent = formatAmount(amount);

var fee = 35;
var total = (parseFloat(amount) || 5000) + fee;
document.getElementById('reviewTotal').textContent = 'KSh ' + total.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });

if (!verified) {
    document.getElementById('verifiedBadge').style.display = 'none';
}

function sendTransfer() {
    window.location.href = 'transfer-kenya-mpesa-processing.php';
}

function editDetails() {
    window.location.href = 'transfer-kenya-mpesa.php';
}
</script>
