<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Verifying recipient</p>
            </div>

            <div class="mpesa-container">

                <div class="verify-card mpesa-card">

                    <div class="verify-number-display">
                        <span class="verify-flag">🇰🇪</span>
                        <span class="verify-number" id="recipientNumber">+254 7XX XXX XXX</span>
                    </div>

                    <div class="verify-state" id="stateLoading">
                        <div class="verify-spinner"></div>
                        <p class="verify-status-text">Verifying recipient details…</p>
                    </div>

                    <div class="verify-state" id="stateSuccess" style="display:none;">
                        <div class="verify-icon verify-icon-success">
                            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="var(--success)" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
                        </div>
                        <p class="verify-status-text verify-text-success">Recipient verified</p>
                        <div class="verify-recipient-details">
                            <span class="verify-recipient-name" id="verifiedName">Wanjiku M.</span>
                            <span class="verify-recipient-num" id="verifiedNumber">+254 712 345 678</span>
                            <span class="verify-pill-verified">Verified</span>
                        </div>
                    </div>

                    <div class="verify-state" id="stateFail" style="display:none;">
                        <div class="verify-icon verify-icon-fail">
                            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="var(--warning)" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><line x1="12" y1="8" x2="12" y2="13"/><circle cx="12" cy="16" r="0.5" fill="var(--warning)"/></svg>
                        </div>
                        <p class="verify-status-text verify-text-fail">We couldn't verify this number</p>
                        <p class="verify-fallback-hint">You can still continue by entering the recipient name.</p>
                        <div class="verify-fallback-input-wrap">
                            <label class="form-label">Recipient name</label>
                            <input type="text" class="verify-fallback-input" id="fallbackName" placeholder="Enter recipient full name" oninput="onFallbackInput()">
                        </div>
                    </div>

                </div>

                <div class="verify-actions" id="verifyActions" style="display:none;">
                    <button class="btn btn-primary ke-proceed-btn" id="btnContinue" onclick="continueToReview()">Continue</button>
                    <button class="btn btn-outline verify-retry-btn" id="btnRetry" style="display:none;" onclick="retryVerification()">Try again</button>
                </div>

                <div class="country-select-back" style="padding-top:22px;">
                    <a href="transfer-kenya-mpesa-recipient.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to recipient
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
var testMode = new URLSearchParams(window.location.search).get('test') || 'success';

function formatPhone(raw) {
    if (!raw) return '+254 XXX XXX XXX';
    var d = raw.replace(/[^0-9]/g, '');
    if (d.length === 9) return '+254 ' + d.substring(0,3) + ' ' + d.substring(3,6) + ' ' + d.substring(6);
    return '+254 ' + d;
}

var storedPhone = sessionStorage.getItem('mpesa_phone') || '712345678';
var formatted = formatPhone(storedPhone);
document.getElementById('recipientNumber').textContent = formatted;
document.getElementById('verifiedNumber').textContent = formatted;

setTimeout(function() {
    document.getElementById('stateLoading').style.display = 'none';

    if (testMode === 'fail') {
        document.getElementById('stateFail').style.display = 'flex';
        document.getElementById('btnRetry').style.display = 'block';
        document.getElementById('btnContinue').disabled = true;
    } else {
        document.getElementById('stateSuccess').style.display = 'flex';
        document.getElementById('btnContinue').disabled = false;
        sessionStorage.setItem('mpesa_recipient_name', 'Wanjiku M.');
        sessionStorage.setItem('mpesa_verified', '1');
    }
    document.getElementById('verifyActions').style.display = 'flex';
}, 1800);

function onFallbackInput() {
    var val = document.getElementById('fallbackName').value.trim();
    document.getElementById('btnContinue').disabled = val.length < 2;
}

function continueToReview() {
    if (testMode === 'fail') {
        var name = document.getElementById('fallbackName').value.trim();
        sessionStorage.setItem('mpesa_recipient_name', name);
        sessionStorage.setItem('mpesa_verified', '0');
    }
    window.location.href = 'transfer-kenya-mpesa-review.php';
}

function retryVerification() {
    document.getElementById('stateFail').style.display = 'none';
    document.getElementById('verifyActions').style.display = 'none';
    document.getElementById('stateLoading').style.display = 'flex';
    document.getElementById('btnRetry').style.display = 'none';

    setTimeout(function() {
        document.getElementById('stateLoading').style.display = 'none';
        if (testMode === 'fail') {
            document.getElementById('stateFail').style.display = 'flex';
            document.getElementById('btnRetry').style.display = 'block';
            document.getElementById('btnContinue').disabled = true;
            onFallbackInput();
        } else {
            document.getElementById('stateSuccess').style.display = 'flex';
            document.getElementById('btnContinue').disabled = false;
        }
        document.getElementById('verifyActions').style.display = 'flex';
    }, 1800);
}
</script>
