<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Send money via M-PESA</p>
            </div>

            <div class="mpesa-container">

                <div class="ke-change-method">
                    <a href="transfer-kenya.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Change method
                    </a>
                </div>

                <div class="mpesa-card">
                    <label class="form-label">Amount to send</label>
                    <div class="mpesa-amount-row">
                        <div class="mpesa-currency-pill">
                            <span class="mpesa-pill-code">KSh</span>
                        </div>
                        <input type="text" class="mpesa-amount-input" id="amountInput" placeholder="0.00" inputmode="decimal" oninput="onAmountInput(this)" autocomplete="off">
                    </div>
                    <div class="mpesa-amount-balance">
                        Available balance: <strong>KSh 124,500.00</strong>
                    </div>
                </div>

                <button class="btn btn-primary ke-proceed-btn" id="btnProceed" disabled onclick="proceedToRecipient()">Proceed</button>

                <div class="country-select-back" style="padding-top:20px;">
                    <a href="transfer.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to country select
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
function onAmountInput(input) {
    input.value = input.value.replace(/[^0-9.]/g, '');
    var parts = input.value.split('.');
    if (parts.length > 2) {
        input.value = parts[0] + '.' + parts.slice(1).join('');
    }
    if (parts[1] && parts[1].length > 2) {
        input.value = parts[0] + '.' + parts[1].substring(0, 2);
    }
    var val = parseFloat(input.value);
    var valid = !isNaN(val) && val >= 10 && val <= 124500;
    document.getElementById('btnProceed').disabled = !valid;
}

function proceedToRecipient() {
    sessionStorage.setItem('mpesa_amount', document.getElementById('amountInput').value.replace(/[^0-9.]/g, ''));
    window.location.href = 'transfer-kenya-mpesa-recipient.php';
}
</script>
