<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Enter paybill number</p>
            </div>

            <div class="mpesa-container">

                <div class="ke-change-method">
                    <a href="transfer-kenya-paybill-amount.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to amount
                    </a>
                </div>

                <div class="mpesa-card">
                    <label class="form-label">Paybill number</label>
                    <div class="till-input-row">
                        <div class="till-icon-pill">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="var(--accent)" stroke-width="1.8"><path d="M14 2H6a2 2 0 00-2 2v16a2 2 0 002 2h12a2 2 0 002-2V8z"/><polyline points="14 2 14 8 20 8"/><line x1="16" y1="13" x2="8" y2="13"/><line x1="16" y1="17" x2="8" y2="17"/><polyline points="10 9 9 9 8 9"/></svg>
                        </div>
                        <input type="tel" class="mpesa-phone-input" id="paybillInput" placeholder="400200" maxlength="10" oninput="onPaybillInput(this)" autofocus>
                    </div>
                    <div class="mpesa-phone-hint" id="paybillHint"><span class="mpesa-hint-default">Enter the business paybill number.</span></div>
                </div>

                <button class="btn btn-primary ke-proceed-btn" id="btnProceed" disabled onclick="proceedToVerify()" style="margin-top:28px;">Proceed</button>

                <div class="country-select-back" style="padding-top:22px;">
                    <a href="transfer-kenya.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Change method
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
function onPaybillInput(input) {
    input.value = input.value.replace(/[^0-9]/g, '');
    var digits = input.value;
    var valid = digits.length >= 4 && digits.length <= 10;
    document.getElementById('btnProceed').disabled = !valid;
    var hint = document.getElementById('paybillHint');
    if (digits.length === 0) {
        hint.innerHTML = '<span class="mpesa-hint-default">Enter the business paybill number.</span>';
    } else if (valid) {
        hint.innerHTML = '<span class="mpesa-hint-valid">Valid paybill number</span>';
    } else if (digits.length < 4) {
        hint.innerHTML = '<span class="mpesa-hint-default">Paybill number must be at least 4 digits.</span>';
    } else {
        hint.innerHTML = '<span class="mpesa-hint-error">Paybill number is too long</span>';
    }
}

function proceedToVerify() {
    sessionStorage.setItem('paybill_number', document.getElementById('paybillInput').value);
    window.location.href = 'transfer-kenya-paybill-verify.php';
}
</script>
