<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Paybill — Business Number</p>
            </div>

            <div class="mpesa-container">

                <div class="ke-change-method">
                    <a href="transfer-kenya-paybill.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to amount
                    </a>
                </div>

                <div class="mpesa-card">
                    <label class="form-label">Business Number</label>
                    <div class="mpesa-phone-row">
                        <div class="mpesa-country-pill" style="padding:0 14px;">
                            <span class="mpesa-pill-code">BIZ</span>
                        </div>
                        <input type="tel" class="mpesa-phone-input" id="bizInput" placeholder="e.g. 247247" maxlength="10" oninput="onBizInput()" style="letter-spacing:0.06em;">
                    </div>
                    <div class="mpesa-phone-hint" id="bizHint"><span class="mpesa-hint-default">Enter the paybill business number.</span></div>
                </div>

                <div class="mpesa-card" style="margin-top:16px;">
                    <label class="form-label">Account Number</label>
                    <div class="mpesa-phone-row">
                        <input type="text" class="mpesa-phone-input" id="accInput" placeholder="e.g. ACC001" maxlength="20" oninput="onBizInput()" style="letter-spacing:0.04em;">
                    </div>
                    <div class="mpesa-phone-hint" id="accHint"><span class="mpesa-hint-default">Enter the account or reference number.</span></div>
                </div>

                <button class="btn btn-primary ke-proceed-btn" id="btnProceed" disabled onclick="proceedPaybill()" style="margin-top:28px;">Proceed</button>

                <div class="country-select-back" style="padding-top:22px;">
                    <a href="transfer-kenya.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Change method
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<div class="sena-toast" id="proceedToast">
    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
    <span>Proceeding...</span>
</div>

<script>
function onBizInput() {
    var bizEl = document.getElementById('bizInput');
    var accEl = document.getElementById('accInput');
    bizEl.value = bizEl.value.replace(/[^0-9]/g, '');
    var bizDigits = bizEl.value;
    var accVal = accEl.value.trim();
    var bizValid = bizDigits.length >= 5 && bizDigits.length <= 10;
    var accValid = accVal.length >= 1;
    document.getElementById('btnProceed').disabled = !(bizValid && accValid);

    var bizHint = document.getElementById('bizHint');
    if (bizDigits.length === 0) {
        bizHint.innerHTML = '<span class="mpesa-hint-default">Enter the paybill business number.</span>';
    } else if (bizValid) {
        bizHint.innerHTML = '<span class="mpesa-hint-valid">Valid business number</span>';
    } else {
        bizHint.innerHTML = '<span class="mpesa-hint-default">Enter the paybill business number.</span>';
    }

    var accHint = document.getElementById('accHint');
    if (accVal.length === 0) {
        accHint.innerHTML = '<span class="mpesa-hint-default">Enter the account or reference number.</span>';
    } else {
        accHint.innerHTML = '<span class="mpesa-hint-valid">Account number entered</span>';
    }
}

function proceedPaybill() {
    var toast = document.getElementById('proceedToast');
    toast.classList.add('show');
    setTimeout(function() { toast.classList.remove('show'); }, 2500);
}
</script>
