<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="result-container">

                <div class="result-card mpesa-card" id="resultSuccess" style="display:none;">
                    <div class="result-icon result-icon-success">
                        <svg width="52" height="52" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="1.8"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
                    </div>
                    <h2 class="result-title result-title-success">Payment successful</h2>
                    <p class="result-reassurance">Your Paybill payment was completed successfully.</p>

                    <div class="result-details">
                        <div class="result-row">
                            <span class="result-label">Reference ID</span>
                            <span class="result-value result-ref-wrap">
                                <span class="result-ref" id="refId">SN-20260224-7X9K2</span>
                                <button class="result-copy-btn" onclick="copyRef()" title="Copy reference ID">
                                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="9" y="9" width="13" height="13" rx="2"/><path d="M5 15H4a2 2 0 01-2-2V4a2 2 0 012-2h9a2 2 0 012 2v1"/></svg>
                                </button>
                            </span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Organization</span>
                            <span class="result-value" id="resultOrg">Kenya Power & Lighting</span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Paybill number</span>
                            <span class="result-value" id="resultPaybill">400200</span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Account number</span>
                            <span class="result-value" id="resultAccount">ACC12345</span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Amount</span>
                            <span class="result-value result-amount" id="resultAmount">KSh 5,000.00</span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Date &amp; time</span>
                            <span class="result-value" id="resultDate">24 Feb 2026, 14:32</span>
                        </div>
                    </div>

                    <div class="result-actions">
                        <a href="transfer-country.php" class="btn btn-primary ke-proceed-btn">Make another transfer</a>
                        <a href="transactions.php" class="btn btn-outline verify-retry-btn">View transactions</a>
                    </div>
                </div>

                <div class="result-card mpesa-card" id="resultError" style="display:none;">
                    <div class="result-icon" id="errorIconWrap"></div>
                    <h2 class="result-title" id="errorTitle"></h2>
                    <p class="result-fail-message" id="errorMessage"></p>
                    <p class="result-error-code" id="errorCode"></p>
                    <div class="result-actions" id="errorActions"></div>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<div class="sena-toast" id="copyToast">
    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
    <span>Reference ID copied</span>
</div>

<script>
var status = new URLSearchParams(window.location.search).get('status') || 'success';
var orgName = sessionStorage.getItem('paybill_org_name') || 'Kenya Power & Lighting';
var paybillNumber = sessionStorage.getItem('paybill_number') || '400200';
var accountNumber = sessionStorage.getItem('paybill_account') || 'ACC12345';
var amount = sessionStorage.getItem('paybill_amount') || '5000';

function formatAmount(raw) {
    var num = parseFloat(raw) || 5000;
    return 'KSh ' + num.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
}

function generateRef() {
    var chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
    var r = '';
    for (var i = 0; i < 5; i++) r += chars.charAt(Math.floor(Math.random() * chars.length));
    var d = new Date();
    var ds = d.getFullYear().toString() + String(d.getMonth()+1).padStart(2,'0') + String(d.getDate()).padStart(2,'0');
    return 'SN-' + ds + '-' + r;
}

function formatDate() {
    var d = new Date();
    var months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
    return d.getDate() + ' ' + months[d.getMonth()] + ' ' + d.getFullYear() + ', ' + String(d.getHours()).padStart(2,'0') + ':' + String(d.getMinutes()).padStart(2,'0');
}

function copyRef() {
    var ref = document.getElementById('refId').textContent;
    if (navigator.clipboard) {
        navigator.clipboard.writeText(ref);
    } else {
        var ta = document.createElement('textarea');
        ta.value = ref;
        ta.style.position = 'fixed';
        ta.style.opacity = '0';
        document.body.appendChild(ta);
        ta.select();
        document.execCommand('copy');
        document.body.removeChild(ta);
    }
    var toast = document.getElementById('copyToast');
    toast.classList.add('show');
    setTimeout(function() { toast.classList.remove('show'); }, 2200);
}

var errorStates = {
    failed: {
        icon: '<svg width="52" height="52" viewBox="0 0 24 24" fill="none" stroke="var(--error)" stroke-width="1.8"><circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/></svg>',
        iconClass: 'result-icon-fail',
        title: 'Payment failed',
        titleClass: 'result-title-fail',
        message: 'Something went wrong while processing your payment. Please try again.',
        code: 'ERR_PAYMENT_FAILED',
        buttons: [
            { label: 'Try again', href: 'transfer-kenya-paybill-amount.php', cls: 'btn btn-primary ke-proceed-btn' },
            { label: 'Back to dashboard', href: 'dashboard.php', cls: 'btn btn-outline verify-retry-btn' }
        ]
    },
    duplicate: {
        icon: '<svg width="52" height="52" viewBox="0 0 24 24" fill="none" stroke="var(--warning)" stroke-width="1.8"><circle cx="12" cy="12" r="10"/><line x1="12" y1="8" x2="12" y2="12"/><line x1="12" y1="16" x2="12.01" y2="16"/></svg>',
        iconClass: 'result-icon-warn',
        title: 'Duplicate transaction detected',
        titleClass: 'result-title-warn',
        message: 'A similar payment was recently processed. Please verify before proceeding.',
        code: 'ERR_DUPLICATE_TXN',
        buttons: [
            { label: 'View transactions', href: 'transactions.php', cls: 'btn btn-primary ke-proceed-btn' },
            { label: 'Back to dashboard', href: 'dashboard.php', cls: 'btn btn-outline verify-retry-btn' }
        ]
    },
    limit: {
        icon: '<svg width="52" height="52" viewBox="0 0 24 24" fill="none" stroke="var(--warning)" stroke-width="1.8"><circle cx="12" cy="12" r="10"/><line x1="12" y1="8" x2="12" y2="12"/><line x1="12" y1="16" x2="12.01" y2="16"/></svg>',
        iconClass: 'result-icon-warn',
        title: 'Transfer limit exceeded',
        titleClass: 'result-title-warn',
        message: 'You have exceeded your daily transaction limit. Please try again tomorrow or contact support.',
        code: 'ERR_LIMIT_EXCEEDED',
        buttons: [
            { label: 'Edit amount', href: 'transfer-kenya-paybill-amount.php', cls: 'btn btn-primary ke-proceed-btn' },
            { label: 'Back to dashboard', href: 'dashboard.php', cls: 'btn btn-outline verify-retry-btn' }
        ]
    },
    insufficient: {
        icon: '<svg width="52" height="52" viewBox="0 0 24 24" fill="none" stroke="var(--error)" stroke-width="1.8"><circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/></svg>',
        iconClass: 'result-icon-fail',
        title: 'Insufficient balance',
        titleClass: 'result-title-fail',
        message: 'Your account does not have enough funds to complete this transaction.',
        code: 'ERR_INSUFFICIENT_FUNDS',
        buttons: [
            { label: 'Add money', href: 'add-money.php', cls: 'btn btn-primary ke-proceed-btn' },
            { label: 'Edit amount', href: 'transfer-kenya-paybill-amount.php', cls: 'btn btn-outline verify-retry-btn' }
        ]
    },
    restricted: {
        icon: '<svg width="52" height="52" viewBox="0 0 24 24" fill="none" stroke="var(--error)" stroke-width="1.8"><circle cx="12" cy="12" r="10"/><path d="M4.93 4.93l14.14 14.14"/></svg>',
        iconClass: 'result-icon-fail',
        title: 'Account restricted',
        titleClass: 'result-title-fail',
        message: 'Your account has been temporarily restricted. Please contact support for assistance.',
        code: 'ERR_ACCOUNT_RESTRICTED',
        buttons: [
            { label: 'Contact support', href: 'dashboard.php', cls: 'btn btn-primary ke-proceed-btn' },
            { label: 'Back to dashboard', href: 'dashboard.php', cls: 'btn btn-outline verify-retry-btn' }
        ]
    },
    network: {
        icon: '<svg width="52" height="52" viewBox="0 0 24 24" fill="none" stroke="var(--warning)" stroke-width="1.8"><circle cx="12" cy="12" r="10"/><line x1="12" y1="8" x2="12" y2="12"/><line x1="12" y1="16" x2="12.01" y2="16"/></svg>',
        iconClass: 'result-icon-warn',
        title: 'Connection error',
        titleClass: 'result-title-warn',
        message: 'We could not reach the payment network. Please check your connection and try again.',
        code: 'ERR_NETWORK_TIMEOUT',
        buttons: [
            { label: 'Try again', href: 'transfer-kenya-paybill-review.php', cls: 'btn btn-primary ke-proceed-btn' },
            { label: 'Back to dashboard', href: 'dashboard.php', cls: 'btn btn-outline verify-retry-btn' }
        ]
    }
};

if (status === 'success') {
    document.getElementById('resultSuccess').style.display = 'flex';
    document.getElementById('refId').textContent = generateRef();
    document.getElementById('resultOrg').textContent = orgName;
    document.getElementById('resultPaybill').textContent = paybillNumber;
    document.getElementById('resultAccount').textContent = accountNumber;
    document.getElementById('resultAmount').textContent = formatAmount(amount);
    document.getElementById('resultDate').textContent = formatDate();
} else {
    var state = errorStates[status] || errorStates.failed;
    document.getElementById('resultError').style.display = 'flex';
    document.getElementById('errorIconWrap').innerHTML = state.icon;
    document.getElementById('errorIconWrap').className = 'result-icon ' + state.iconClass;
    document.getElementById('errorTitle').textContent = state.title;
    document.getElementById('errorTitle').className = 'result-title ' + state.titleClass;
    document.getElementById('errorMessage').textContent = state.message;
    document.getElementById('errorCode').textContent = 'Error code: ' + state.code;
    var btns = '';
    for (var i = 0; i < state.buttons.length; i++) {
        btns += '<a href="' + state.buttons[i].href + '" class="' + state.buttons[i].cls + '">' + state.buttons[i].label + '</a>';
    }
    document.getElementById('errorActions').innerHTML = btns;
}
</script>
