<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Review your transfer</p>
            </div>

            <div class="mpesa-container">

                <div class="review-card mpesa-card">

                    <h3 class="review-title">Transfer Review</h3>

                    <div class="review-rows">
                        <div class="review-row">
                            <span class="review-label">Method</span>
                            <span class="review-value">Paybill</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Amount</span>
                            <span class="review-value review-amount" id="reviewAmount">KSh 5,000.00</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Paybill number</span>
                            <span class="review-value" id="reviewPaybill">400200</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Organization</span>
                            <span class="review-value" id="reviewOrg">
                                <span id="orgText">Kenya Power & Lighting</span>
                                <span class="verify-pill-verified verify-pill-sm" id="verifiedBadge">Verified</span>
                            </span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Account number</span>
                            <span class="review-value" id="reviewAccount">ACC12345</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Fees</span>
                            <span class="review-value review-fees">KSh 0.00</span>
                        </div>
                        <div class="review-divider review-divider-total"></div>
                        <div class="review-row review-row-total">
                            <span class="review-label">Total debit</span>
                            <span class="review-value review-total" id="reviewTotal">KSh 5,000.00</span>
                        </div>
                    </div>

                </div>

                <div class="review-actions">
                    <button class="btn btn-primary ke-proceed-btn" onclick="sendTransfer()">Send transfer</button>
                    <button class="btn btn-outline verify-retry-btn" onclick="editDetails()">Edit details</button>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
var orgName = sessionStorage.getItem('paybill_org_name') || 'Kenya Power & Lighting';
var paybillNumber = sessionStorage.getItem('paybill_number') || '400200';
var accountNumber = sessionStorage.getItem('paybill_account') || 'ACC12345';
var amount = sessionStorage.getItem('paybill_amount') || '5000';
var verified = sessionStorage.getItem('paybill_verified') === '1';

function formatAmount(raw) {
    var num = parseFloat(raw) || 5000;
    return 'KSh ' + num.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
}

document.getElementById('orgText').textContent = orgName;
document.getElementById('reviewPaybill').textContent = paybillNumber;
document.getElementById('reviewAccount').textContent = accountNumber;
document.getElementById('reviewAmount').textContent = formatAmount(amount);
document.getElementById('reviewTotal').textContent = formatAmount(amount);

if (!verified) {
    document.getElementById('verifiedBadge').style.display = 'none';
}

function sendTransfer() {
    window.location.href = 'transfer-kenya-paybill-processing.php';
}

function editDetails() {
    window.location.href = 'transfer-kenya-paybill-amount.php';
}
</script>
