<?php $pageTitle = 'Transfer — Kenya'; $currentPage = 'transfer'; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Kenya</h1>
                <p>Verifying organization</p>
            </div>

            <div class="mpesa-container">

                <div class="verify-card mpesa-card">

                    <div class="verify-number-display">
                        <span class="verify-flag">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="var(--accent)" stroke-width="1.8"><path d="M14 2H6a2 2 0 00-2 2v16a2 2 0 002 2h12a2 2 0 002-2V8z"/><polyline points="14 2 14 8 20 8"/><line x1="16" y1="13" x2="8" y2="13"/><line x1="16" y1="17" x2="8" y2="17"/><polyline points="10 9 9 9 8 9"/></svg>
                        </span>
                        <span class="verify-number" id="paybillDisplay">Paybill 400200</span>
                    </div>

                    <div class="verify-state" id="stateLoading">
                        <div class="verify-spinner"></div>
                        <p class="verify-status-text">Verifying organization details&hellip;</p>
                    </div>

                    <div class="verify-state" id="stateSuccess" style="display:none;">
                        <div class="verify-icon verify-icon-success">
                            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
                        </div>
                        <p class="verify-status-text verify-text-success">Organization verified</p>
                        <div class="verify-recipient-details">
                            <span class="verify-recipient-name" id="verifiedName">Kenya Power & Lighting</span>
                            <span class="verify-recipient-num" id="verifiedPaybill">Paybill 400200</span>
                            <span class="verify-pill-verified">Verified</span>
                        </div>

                        <div class="paybill-account-section">
                            <label class="form-label">Account number</label>
                            <input type="text" class="verify-fallback-input" id="accountInput" placeholder="e.g. ACC12345" oninput="onAccountInput()" autofocus>
                            <div class="mpesa-phone-hint"><span class="mpesa-hint-default">Enter your account/reference number.</span></div>
                        </div>
                    </div>

                    <div class="verify-state" id="stateFail" style="display:none;">
                        <div class="verify-icon verify-icon-fail">
                            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="var(--warning)" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><line x1="12" y1="8" x2="12" y2="13"/><circle cx="12" cy="16" r="0.5" fill="var(--warning)"/></svg>
                        </div>
                        <p class="verify-status-text verify-text-fail">We couldn't verify this paybill number.</p>
                        <p class="verify-fallback-hint">Enter organization details manually.</p>
                        <div class="verify-fallback-input-wrap">
                            <label class="form-label">Organization name</label>
                            <input type="text" class="verify-fallback-input" id="fallbackName" placeholder="Enter organization name" oninput="onFallbackInput()">
                        </div>
                        <div class="verify-fallback-input-wrap" style="margin-top:16px;">
                            <label class="form-label">Account number</label>
                            <input type="text" class="verify-fallback-input" id="fallbackAccount" placeholder="e.g. ACC12345" oninput="onFallbackInput()">
                            <div class="mpesa-phone-hint"><span class="mpesa-hint-default">Enter your account/reference number.</span></div>
                        </div>
                    </div>

                </div>

                <div class="verify-actions" id="verifyActions" style="display:none;">
                    <button class="btn btn-primary ke-proceed-btn" id="btnContinue" disabled onclick="continueToReview()">Continue</button>
                    <button class="btn btn-outline verify-retry-btn" id="btnRetry" style="display:none;" onclick="retryVerification()">Try again</button>
                </div>

                <div class="country-select-back" style="padding-top:22px;">
                    <a href="transfer-kenya-paybill-number.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to paybill number
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
var testMode = new URLSearchParams(window.location.search).get('test') || 'success';
var storedPaybill = sessionStorage.getItem('paybill_number') || '400200';

document.getElementById('paybillDisplay').textContent = 'Paybill ' + storedPaybill;
document.getElementById('verifiedPaybill').textContent = 'Paybill ' + storedPaybill;

setTimeout(function() {
    document.getElementById('stateLoading').style.display = 'none';

    if (testMode === 'fail') {
        document.getElementById('stateFail').style.display = 'flex';
        document.getElementById('btnRetry').style.display = 'block';
        document.getElementById('btnContinue').disabled = true;
    } else {
        document.getElementById('stateSuccess').style.display = 'flex';
        document.getElementById('btnContinue').disabled = true;
        sessionStorage.setItem('paybill_org_name', 'Kenya Power & Lighting');
        sessionStorage.setItem('paybill_verified', '1');
    }
    document.getElementById('verifyActions').style.display = 'flex';
}, 1600);

function onAccountInput() {
    var val = document.getElementById('accountInput').value.trim();
    document.getElementById('btnContinue').disabled = val.length < 1;
}

function onFallbackInput() {
    var name = document.getElementById('fallbackName').value.trim();
    var acc = document.getElementById('fallbackAccount').value.trim();
    document.getElementById('btnContinue').disabled = name.length < 2 || acc.length < 1;
}

function continueToReview() {
    if (testMode === 'fail') {
        var name = document.getElementById('fallbackName').value.trim();
        var acc = document.getElementById('fallbackAccount').value.trim();
        sessionStorage.setItem('paybill_org_name', name);
        sessionStorage.setItem('paybill_account', acc);
        sessionStorage.setItem('paybill_verified', '0');
    } else {
        var acc = document.getElementById('accountInput').value.trim();
        sessionStorage.setItem('paybill_account', acc);
    }
    window.location.href = 'transfer-kenya-paybill-review.php';
}

function retryVerification() {
    document.getElementById('stateFail').style.display = 'none';
    document.getElementById('verifyActions').style.display = 'none';
    document.getElementById('stateLoading').style.display = 'flex';
    document.getElementById('btnRetry').style.display = 'none';

    setTimeout(function() {
        document.getElementById('stateLoading').style.display = 'none';
        if (testMode === 'fail') {
            document.getElementById('stateFail').style.display = 'flex';
            document.getElementById('btnRetry').style.display = 'block';
            document.getElementById('btnContinue').disabled = true;
            onFallbackInput();
        } else {
            document.getElementById('stateSuccess').style.display = 'flex';
            document.getElementById('btnContinue').disabled = true;
        }
        document.getElementById('verifyActions').style.display = 'flex';
    }, 1600);
}
</script>
