<?php $pageTitle = 'Transfer — Nigeria'; $currentPage = 'transfer'; $userTier = isset($_GET['tier']) ? (int)$_GET['tier'] : 1; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Nigeria</h1>
                <p>Recipient</p>
            </div>

            <div class="mpesa-container">

                <div class="ke-change-method">
                    <a href="transfer-nigeria.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to amount
                    </a>
                </div>

                <div class="ng-recipient-card mpesa-card">

                    <div id="favSection" class="ng-fav-section" style="display:none;">
                        <div class="ng-fav-header">
                            <span class="form-label">
                                <svg width="12" height="12" viewBox="0 0 24 24" fill="#E0A832" stroke="#E0A832" stroke-width="2"><polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"/></svg>
                                Favorites
                            </span>
                        </div>
                        <div class="ng-fav-chips" id="favChips"></div>
                    </div>

                    <div id="favDivider" class="ng-section-divider" style="display:none;"></div>

                    <div id="savedSection" class="ng-saved-section" style="display:none;">
                        <div class="ng-saved-header">
                            <span class="form-label">Saved recipients</span>
                            <span class="ng-saved-header-actions">
                                <button class="ng-new-recipient-btn" onclick="scrollToInputs()">+ New</button>
                                <button class="ng-view-all-btn" id="viewAllBtn" onclick="openAllRecipients()" style="display:none;">View all</button>
                            </span>
                        </div>
                        <div class="ng-saved-list" id="savedList"></div>
                    </div>

                    <div id="sectionDivider" class="ng-section-divider" style="display:none;"></div>

                    <div class="ng-manual-section">
                        <label class="form-label">Account number</label>
                        <input type="text" class="mpesa-phone-input" id="accountInput" placeholder="0123456789" maxlength="10" inputmode="numeric" oninput="onAccountInput(this)" autocomplete="off">

                        <label class="form-label" style="margin-top:16px;">Bank</label>
                        <div class="ng-bank-select-wrap">
                            <button class="ng-bank-select-btn" id="bankSelectBtn" onclick="toggleBankDropdown()">
                                <span class="ng-bank-select-text" id="bankText">Select bank</span>
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9"/></svg>
                            </button>
                            <div class="ng-bank-dropdown" id="bankDropdown">
                                <div class="ng-bank-search-wrap">
                                    <svg class="mpesa-search-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="11" cy="11" r="8"/><line x1="21" y1="21" x2="16.65" y2="16.65"/></svg>
                                    <input type="text" class="mpesa-search-input" id="bankSearch" placeholder="Search bank" oninput="filterBanks()" autocomplete="off">
                                </div>
                                <div class="ng-bank-list" id="bankList"></div>
                            </div>
                        </div>
                    </div>

                    <div class="ng-error-banner" id="errorBanner" style="display:none;">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="var(--error)" stroke-width="2"><circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/></svg>
                        <span>Account not found. Please check the number and bank.</span>
                    </div>

                </div>

                <button class="btn btn-primary ke-proceed-btn" id="btnContinue" disabled onclick="proceedToVerify()">Continue</button>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<div class="sena-modal-overlay" id="allRecipientsModal">
    <div class="sena-modal mpesa-recipients-modal">
        <div class="mpesa-modal-header">
            <h3 class="sena-modal-title">Saved recipients</h3>
            <button class="mpesa-modal-close" onclick="closeAllRecipients()">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/></svg>
            </button>
        </div>
        <div class="mpesa-search-wrap">
            <svg class="mpesa-search-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="11" cy="11" r="8"/><line x1="21" y1="21" x2="16.65" y2="16.65"/></svg>
            <input type="text" class="mpesa-search-input" id="modalSearch" placeholder="Search name or account" oninput="filterModalRecipients()">
        </div>
        <div class="mpesa-recipient-list" id="modalRecipientList"></div>
    </div>
</div>

<script>
var favorites = [
    { name: 'My Kuda', account: '2045671831', masked: '••••1831', bank: 'Kuda Bank', bankShort: 'Kuda' },
    { name: 'Dad — UBA', account: '0123456789', masked: '••••6789', bank: 'United Bank for Africa', bankShort: 'UBA' }
];

var savedRecipients = [
    { name: 'Adebayo Olufemi', account: '0123456789', masked: '012 ••• 6789', bank: 'Access Bank', fav: false },
    { name: 'Chidinma Okafor', account: '2045671831', masked: '204 ••• 1831', bank: 'GTBank', fav: false },
    { name: 'Emeka Nwosu', account: '3098765432', masked: '309 ••• 5432', bank: 'First Bank', fav: false },
    { name: 'Fatima Bello', account: '1122334455', masked: '112 ••• 4455', bank: 'Zenith Bank', fav: false },
    { name: 'Ibrahim Musa', account: '5566778899', masked: '556 ••• 8899', bank: 'UBA', fav: false }
];

var banks = [
    'Access Bank', 'Citibank Nigeria', 'Ecobank Nigeria', 'Fidelity Bank',
    'First Bank of Nigeria', 'First City Monument Bank', 'Globus Bank',
    'Guaranty Trust Bank', 'Heritage Bank', 'Jaiz Bank', 'Keystone Bank',
    'Kuda Bank', 'Opay', 'Palmpay', 'Polaris Bank', 'Providus Bank',
    'Stanbic IBTC Bank', 'Standard Chartered', 'Sterling Bank',
    'SunTrust Bank', 'Titan Trust Bank', 'Union Bank of Nigeria',
    'United Bank for Africa', 'Unity Bank', 'VFD Microfinance Bank',
    'Wema Bank', 'Zenith Bank'
];

var selectedBank = '';
var returnError = new URLSearchParams(window.location.search).get('error');

function renderFavorites() {
    if (favorites.length === 0) {
        document.getElementById('favSection').style.display = 'none';
        document.getElementById('favDivider').style.display = 'none';
        return;
    }
    document.getElementById('favSection').style.display = 'block';
    document.getElementById('favDivider').style.display = 'block';
    var show = favorites.slice(0, 3);
    var html = '';
    for (var i = 0; i < show.length; i++) {
        var f = show[i];
        html += '<button class="ng-fav-chip" onclick="tapFavorite('+i+')">' +
            '<span class="ng-fav-chip-star">&#9733;</span>' +
            '<span class="ng-fav-chip-info">' +
                '<span class="ng-fav-chip-name">'+f.name+'</span>' +
                '<span class="ng-fav-chip-detail">'+f.masked+' · '+f.bankShort+'</span>' +
            '</span>' +
        '</button>';
    }
    document.getElementById('favChips').innerHTML = html;
}

function tapFavorite(idx) {
    var f = favorites[idx];
    document.getElementById('accountInput').value = f.account;
    selectBankByName(f.bank);
    document.getElementById('errorBanner').style.display = 'none';
    checkReady();
    scrollToInputs();
}

function scrollToInputs() {
    var el = document.getElementById('accountInput');
    el.scrollIntoView({ behavior: 'smooth', block: 'center' });
    setTimeout(function(){ el.focus(); }, 300);
}

function renderSaved() {
    if (savedRecipients.length === 0) {
        document.getElementById('savedSection').style.display = 'none';
        document.getElementById('sectionDivider').style.display = 'none';
        return;
    }
    document.getElementById('savedSection').style.display = 'block';
    document.getElementById('sectionDivider').style.display = 'block';
    var show = savedRecipients.slice(0, 3);
    if (savedRecipients.length > 3) document.getElementById('viewAllBtn').style.display = 'inline';
    var html = '';
    for (var i = 0; i < show.length; i++) {
        var r = show[i];
        html += '<button class="ng-saved-row" onclick="pickSaved('+i+')">' +
            '<div class="ng-saved-row-left">' +
                '<span class="ng-saved-row-name">'+r.name+'</span>' +
                '<span class="ng-saved-row-detail">'+r.masked+' &middot; '+r.bank+'</span>' +
            '</div>' +
            '<svg class="ng-saved-row-arrow" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg>' +
        '</button>';
    }
    document.getElementById('savedList').innerHTML = html;
}

function pickSaved(idx) {
    var r = savedRecipients[idx];
    closeAllRecipients();
    document.getElementById('accountInput').value = r.account;
    selectBankByName(r.bank);
    document.getElementById('errorBanner').style.display = 'none';
    checkReady();
    scrollToInputs();
}

function selectBankByName(name) {
    selectedBank = name;
    document.getElementById('bankText').textContent = name;
    document.getElementById('bankText').classList.add('ng-bank-selected');
    closeBankDropdown();
}

function renderBanks(list) {
    var html = '';
    for (var i = 0; i < list.length; i++) {
        html += '<button class="ng-bank-item" onclick="pickBank(\''+list[i].replace(/'/g, "\\'")+'\')">' +
            '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M3 21h18M3 10h18M5 6l7-3 7 3M4 10v11M20 10v11M8 14v3M12 14v3M16 14v3"/></svg>' +
            '<span>'+list[i]+'</span>' +
        '</button>';
    }
    if (!list.length) html = '<div class="mpesa-recipient-empty">No banks found</div>';
    document.getElementById('bankList').innerHTML = html;
}

function toggleBankDropdown() {
    var dd = document.getElementById('bankDropdown');
    if (dd.classList.contains('show')) { closeBankDropdown(); return; }
    dd.classList.add('show');
    document.getElementById('bankSearch').value = '';
    renderBanks(banks);
    setTimeout(function(){ document.getElementById('bankSearch').focus(); }, 50);
}

function closeBankDropdown() {
    document.getElementById('bankDropdown').classList.remove('show');
}

function filterBanks() {
    var q = document.getElementById('bankSearch').value.toLowerCase();
    renderBanks(banks.filter(function(b){ return b.toLowerCase().indexOf(q) !== -1; }));
}

function pickBank(name) {
    selectBankByName(name);
    checkReady();
}

function onAccountInput(input) {
    input.value = input.value.replace(/[^0-9]/g, '');
    document.getElementById('errorBanner').style.display = 'none';
    checkReady();
}

function checkReady() {
    var acc = document.getElementById('accountInput').value.replace(/[^0-9]/g, '');
    document.getElementById('btnContinue').disabled = !(acc.length === 10 && selectedBank);
}

function proceedToVerify() {
    sessionStorage.setItem('ng_account', document.getElementById('accountInput').value);
    sessionStorage.setItem('ng_bank', selectedBank);
    sessionStorage.removeItem('ng_saved_name');
    window.location.href = 'transfer-nigeria-verify.php';
}

function openAllRecipients() {
    renderModalRecipients(savedRecipients);
    document.getElementById('modalSearch').value = '';
    var modal = document.getElementById('allRecipientsModal');
    modal.style.display = 'flex';
    setTimeout(function(){ modal.classList.add('show'); }, 10);
}

function closeAllRecipients() {
    var modal = document.getElementById('allRecipientsModal');
    modal.classList.remove('show');
    setTimeout(function(){ modal.style.display = 'none'; }, 250);
}

function renderModalRecipients(list) {
    var html = '';
    for (var i = 0; i < list.length; i++) {
        var r = list[i];
        html += '<button class="mpesa-recipient-item" onclick="pickModalSaved('+i+')">' +
            '<span class="mpesa-recipient-info" style="gap:2px;">' +
                '<span class="mpesa-recipient-name">'+r.name+'</span>' +
                '<span class="mpesa-recipient-number">'+r.masked+' &middot; '+r.bank+'</span>' +
            '</span>' +
            '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="opacity:0.3;flex-shrink:0;"><polyline points="9 18 15 12 9 6"/></svg>' +
        '</button>';
    }
    if (!list.length) html = '<div class="mpesa-recipient-empty">No recipients found</div>';
    document.getElementById('modalRecipientList').innerHTML = html;
}

function filterModalRecipients() {
    var q = document.getElementById('modalSearch').value.toLowerCase();
    renderModalRecipients(savedRecipients.filter(function(r){
        return r.name.toLowerCase().indexOf(q) !== -1 || r.account.indexOf(q) !== -1 || r.bank.toLowerCase().indexOf(q) !== -1;
    }));
}

function pickModalSaved(idx) {
    pickSaved(idx);
}

document.getElementById('allRecipientsModal').addEventListener('click', function(e){ if(e.target===this) closeAllRecipients(); });
document.addEventListener('keydown', function(e){ if(e.key==='Escape'){ closeAllRecipients(); closeBankDropdown(); }});
document.addEventListener('click', function(e){
    var dd = document.getElementById('bankDropdown');
    var btn = document.getElementById('bankSelectBtn');
    if(dd.classList.contains('show') && !dd.contains(e.target) && !btn.contains(e.target)) closeBankDropdown();
});

if (returnError === '1') {
    document.getElementById('errorBanner').style.display = 'flex';
}

renderFavorites();
renderSaved();
</script>
