<?php $pageTitle = 'Transfer — Nigeria'; $currentPage = 'transfer'; $userTier = isset($_GET['tier']) ? (int)$_GET['tier'] : 1; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="result-container ng-result-container">

                <div class="result-card mpesa-card" id="resultSuccess" style="display:none;">
                    <div class="result-icon ng-result-icon">
                        <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="1.6"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
                    </div>
                    <h2 class="result-title result-title-success">Transfer sent</h2>
                    <p class="result-reassurance">Your bank transfer was completed successfully.</p>
                    <div class="result-details">
                        <div class="result-row">
                            <span class="result-label">Reference ID</span>
                            <span class="result-value result-ref-wrap">
                                <span class="result-ref" id="refId">SN-20260225-XXXXX</span>
                                <button class="result-copy-btn" onclick="copyRef()" title="Copy reference ID">
                                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="9" y="9" width="13" height="13" rx="2"/><path d="M5 15H4a2 2 0 01-2-2V4a2 2 0 012-2h9a2 2 0 012 2v1"/></svg>
                                </button>
                            </span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Account name</span>
                            <span class="result-value" id="resultName">Chidinma Okafor</span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Bank</span>
                            <span class="result-value" id="resultBank">GTBank</span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Amount</span>
                            <span class="result-value result-amount" id="resultAmount">NGN 50,000.00</span>
                        </div>
                        <div class="result-divider"></div>
                        <div class="result-row">
                            <span class="result-label">Date &amp; time</span>
                            <span class="result-value" id="resultDate">25 Feb 2026, 14:32</span>
                        </div>
                    </div>
                    <div class="result-actions">
                        <a href="transfer.php" class="btn btn-primary ke-proceed-btn">Make another transfer</a>
                        <a href="transactions.php" class="btn btn-outline verify-retry-btn">View transactions</a>
                    </div>
                </div>

                <div class="result-card mpesa-card" id="resultFailed" style="display:none;">
                    <div class="result-icon ng-result-icon">
                        <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="var(--error)" stroke-width="1.6"><circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/></svg>
                    </div>
                    <h2 class="result-title result-title-fail">Transfer failed</h2>
                    <p class="result-fail-message">The transfer could not be completed. Please try again.</p>
                    <span class="result-error-code">ERR_PAYMENT_FAILED</span>
                    <div class="result-actions">
                        <a href="transfer-nigeria.php" class="btn btn-primary ke-proceed-btn">Try again</a>
                        <a href="dashboard.php" class="btn btn-outline verify-retry-btn">Back to dashboard</a>
                    </div>
                </div>

                <div class="result-card mpesa-card" id="resultDuplicate" style="display:none;">
                    <div class="result-icon ng-result-icon">
                        <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="#E0A832" stroke-width="1.6"><circle cx="12" cy="12" r="10"/><line x1="12" y1="8" x2="12" y2="12"/><line x1="12" y1="16" x2="12.01" y2="16"/></svg>
                    </div>
                    <h2 class="result-title result-title-warn">Possible duplicate</h2>
                    <p class="result-fail-message">A similar transfer was recently sent to this account. Please check your transaction history.</p>
                    <span class="result-error-code">ERR_DUPLICATE_TXN</span>
                    <div class="result-actions">
                        <a href="transactions.php" class="btn btn-primary ke-proceed-btn">View transactions</a>
                        <a href="transfer-nigeria.php" class="btn btn-outline verify-retry-btn">Send anyway</a>
                    </div>
                </div>

                <div class="result-card mpesa-card" id="resultLimit" style="display:none;">
                    <div class="result-icon ng-result-icon">
                        <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="#E0A832" stroke-width="1.6"><circle cx="12" cy="12" r="10"/><line x1="12" y1="8" x2="12" y2="12"/><line x1="12" y1="16" x2="12.01" y2="16"/></svg>
                    </div>
                    <h2 class="result-title result-title-warn">Limit exceeded</h2>
                    <p class="result-fail-message">This transfer exceeds your daily limit. Upgrade your account for higher limits.</p>
                    <span class="result-error-code">ERR_LIMIT_EXCEEDED</span>
                    <div class="result-actions">
                        <a href="upgrade.php" class="btn btn-primary ke-proceed-btn">Upgrade account</a>
                        <a href="transfer-nigeria.php" class="btn btn-outline verify-retry-btn">Change amount</a>
                    </div>
                </div>

                <div class="result-card mpesa-card" id="resultAccount" style="display:none;">
                    <div class="result-icon ng-result-icon">
                        <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="var(--error)" stroke-width="1.6"><circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/></svg>
                    </div>
                    <h2 class="result-title result-title-fail">Invalid account</h2>
                    <p class="result-fail-message">The destination account could not be credited. Please verify the account details and try again.</p>
                    <span class="result-error-code">ERR_INVALID_ACCOUNT</span>
                    <div class="result-actions">
                        <a href="transfer-nigeria-recipient.php" class="btn btn-primary ke-proceed-btn">Check account details</a>
                        <a href="dashboard.php" class="btn btn-outline verify-retry-btn">Back to dashboard</a>
                    </div>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<div class="sena-toast" id="copyToast">
    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="#2DCC9F" stroke-width="2.5"><circle cx="12" cy="12" r="10"/><polyline points="9 12 12 15 16 10"/></svg>
    <span>Reference ID copied</span>
</div>

<script>
var status = new URLSearchParams(window.location.search).get('status') || 'success';
var accountName = sessionStorage.getItem('ng_account_name') || 'Chidinma Okafor';
var bank = sessionStorage.getItem('ng_bank') || 'GTBank';
var amount = sessionStorage.getItem('ng_amount') || '50000';

function fmtAmt(raw) {
    var n = parseFloat(raw) || 50000;
    return 'NGN ' + n.toLocaleString('en-US', {minimumFractionDigits:2, maximumFractionDigits:2});
}

function generateRef() {
    var chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
    var r = '';
    for (var i = 0; i < 5; i++) r += chars.charAt(Math.floor(Math.random() * chars.length));
    var d = new Date();
    var ds = d.getFullYear().toString() + String(d.getMonth()+1).padStart(2,'0') + String(d.getDate()).padStart(2,'0');
    return 'SN-' + ds + '-' + r;
}

function formatDate() {
    var d = new Date();
    var months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
    return d.getDate() + ' ' + months[d.getMonth()] + ' ' + d.getFullYear() + ', ' + String(d.getHours()).padStart(2,'0') + ':' + String(d.getMinutes()).padStart(2,'0');
}

function copyRef() {
    var ref = document.getElementById('refId').textContent;
    if (navigator.clipboard) navigator.clipboard.writeText(ref);
    var toast = document.getElementById('copyToast');
    toast.classList.add('show');
    setTimeout(function(){ toast.classList.remove('show'); }, 2200);
}

var map = { success:'resultSuccess', failed:'resultFailed', duplicate:'resultDuplicate', limit:'resultLimit', account:'resultAccount' };
var elId = map[status] || 'resultSuccess';
document.getElementById(elId).style.display = 'flex';

if (status === 'success') {
    document.getElementById('refId').textContent = generateRef();
    document.getElementById('resultName').textContent = accountName;
    document.getElementById('resultBank').textContent = bank;
    document.getElementById('resultAmount').textContent = fmtAmt(amount);
    document.getElementById('resultDate').textContent = formatDate();
}
</script>
