<?php $pageTitle = 'Transfer — Nigeria'; $currentPage = 'transfer'; $userTier = isset($_GET['tier']) ? (int)$_GET['tier'] : 1; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Nigeria</h1>
                <p>Review your transfer</p>
            </div>

            <div class="mpesa-container">

                <div class="review-card mpesa-card ng-review-card">
                    <h3 class="review-title">Transfer Review</h3>
                    <div class="review-rows">
                        <div class="review-row">
                            <span class="review-label">Method</span>
                            <span class="review-value">Nigeria Bank Transfer</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Amount</span>
                            <span class="review-value review-amount" id="reviewAmount">NGN 50,000.00</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Bank</span>
                            <span class="review-value" id="reviewBank">GTBank</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Account number</span>
                            <span class="review-value" id="reviewAccount">2045671831</span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Account name</span>
                            <span class="review-value" id="reviewName">
                                <span id="nameText">Chidinma Okafor</span>
                                <span class="ng-verified-badge">Verified</span>
                            </span>
                        </div>
                        <div class="review-divider"></div>
                        <div class="review-row">
                            <span class="review-label">Fees</span>
                            <span class="review-value review-fees">NGN 50.00</span>
                        </div>
                        <div class="review-divider review-divider-total"></div>
                        <div class="review-row review-row-total">
                            <span class="review-label">Total debit</span>
                            <span class="review-value ng-review-total" id="reviewTotal">NGN 50,050.00</span>
                        </div>
                    </div>
                </div>

                <div class="ng-save-options">
                    <label class="ng-save-check">
                        <input type="checkbox" id="saveCheck" onchange="onSaveToggle()">
                        <span class="ng-check-box"></span>
                        <span class="ng-check-text">Save this recipient</span>
                    </label>
                    <div class="ng-save-nested" id="saveNested" style="display:none;">
                        <div class="ng-save-label-row">
                            <label class="ng-save-label-text" for="labelInput">Label</label>
                            <input type="text" class="ng-save-label-input" id="labelInput" placeholder="e.g. My Kuda" maxlength="30" autocomplete="off">
                        </div>
                        <label class="ng-save-check">
                            <input type="checkbox" id="favCheck">
                            <span class="ng-check-box ng-check-box-star"></span>
                            <span class="ng-check-text">
                                <svg width="12" height="12" viewBox="0 0 24 24" fill="#E0A832" stroke="#E0A832" stroke-width="2"><polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"/></svg>
                                Mark as favorite
                            </span>
                        </label>
                    </div>
                </div>

                <div class="review-actions">
                    <button class="btn btn-primary ke-proceed-btn" onclick="sendTransfer()">Send Transfer</button>
                    <button class="btn btn-outline verify-retry-btn" onclick="editDetails()">Edit Details</button>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
var accountName = sessionStorage.getItem('ng_account_name') || 'Chidinma Okafor';
var account = sessionStorage.getItem('ng_account') || '2045671831';
var bank = sessionStorage.getItem('ng_bank') || 'GTBank';
var amount = sessionStorage.getItem('ng_amount') || '50000';

function fmtAmt(raw) {
    var n = parseFloat(raw) || 50000;
    return 'NGN ' + n.toLocaleString('en-US', {minimumFractionDigits:2, maximumFractionDigits:2});
}

document.getElementById('nameText').textContent = accountName;
document.getElementById('reviewAccount').textContent = account;
document.getElementById('reviewBank').textContent = bank;
document.getElementById('reviewAmount').textContent = fmtAmt(amount);

var fee = 50;
var total = (parseFloat(amount) || 50000) + fee;
document.getElementById('reviewTotal').textContent = 'NGN ' + total.toLocaleString('en-US', {minimumFractionDigits:2, maximumFractionDigits:2});

function onSaveToggle() {
    var checked = document.getElementById('saveCheck').checked;
    document.getElementById('saveNested').style.display = checked ? 'block' : 'none';
    if (!checked) {
        document.getElementById('favCheck').checked = false;
        document.getElementById('labelInput').value = '';
    }
}

function sendTransfer() { window.location.href = 'transfer-nigeria-processing.php'; }
function editDetails() { window.location.href = 'transfer-nigeria-recipient.php'; }
</script>
