<?php $pageTitle = 'Transfer — Nigeria'; $currentPage = 'transfer'; $userTier = isset($_GET['tier']) ? (int)$_GET['tier'] : 1; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Transfer — Nigeria</h1>
                <p>Verifying account</p>
            </div>

            <div class="mpesa-container">

                <div class="ng-verify-page-card mpesa-card">
                    <div class="processing-spinner-wrap">
                        <div class="processing-spinner">
                            <svg width="48" height="48" viewBox="0 0 56 56" fill="none">
                                <circle cx="28" cy="28" r="24" stroke="rgba(255,255,255,0.06)" stroke-width="4"/>
                                <circle cx="28" cy="28" r="24" stroke="url(#verifyGrad)" stroke-width="4" stroke-linecap="round" stroke-dasharray="100 51"/>
                                <defs>
                                    <linearGradient id="verifyGrad" x1="0" y1="0" x2="56" y2="56">
                                        <stop offset="0%" stop-color="#1F6FEB"/>
                                        <stop offset="100%" stop-color="#2DCC9F"/>
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                    </div>
                    <h2 class="ng-verify-page-title">Verifying account details</h2>
                    <p class="ng-verify-page-sub">Please wait while we confirm the account name.</p>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>

<script>
var account = sessionStorage.getItem('ng_account') || '';
var bank = sessionStorage.getItem('ng_bank') || '';
var savedName = sessionStorage.getItem('ng_saved_name') || '';

var savedRecipients = [
    { account: '0123456789', name: 'Adebayo Olufemi' },
    { account: '2045671831', name: 'Chidinma Okafor' },
    { account: '3098765432', name: 'Emeka Nwosu' },
    { account: '1122334455', name: 'Fatima Bello' },
    { account: '5566778899', name: 'Ibrahim Musa' }
];

function getDemoName(acc) {
    if (savedName) return savedName;
    for (var i = 0; i < savedRecipients.length; i++) {
        if (savedRecipients[i].account === acc) return savedRecipients[i].name;
    }
    var last2 = parseInt(acc.substring(8));
    if (last2 % 7 === 0) return null;
    var names = ['Oluwaseun Adeyemi','Ngozi Eze','Tunde Bakare','Aisha Mohammed','Chukwudi Ibe'];
    return names[last2 % names.length];
}

setTimeout(function(){
    var resolvedName = getDemoName(account);
    if (resolvedName) {
        sessionStorage.setItem('ng_account_name', resolvedName);
        sessionStorage.setItem('ng_verified', '1');
        window.location.href = 'transfer-nigeria-review.php';
    } else {
        sessionStorage.removeItem('ng_account_name');
        sessionStorage.removeItem('ng_verified');
        window.location.href = 'transfer-nigeria-recipient.php?error=1';
    }
}, 2000);
</script>
