<?php $pageTitle = 'Upgrade Account'; $currentPage = 'profile'; $userTier = isset($_GET['tier']) ? (int)$_GET['tier'] : 1; ?>
<?php include 'partials/header.php'; ?>

<div class="app-layout">
    <?php include 'partials/sidebar.php'; ?>
    <div class="app-main">
        <?php include 'partials/topbar.php'; ?>
        <main class="app-content">

            <div class="page-header">
                <h1>Upgrade Account</h1>
                <p>Increase your limits and unlock features</p>
            </div>

            <div class="upgrade-container">

                <div class="upgrade-current card">
                    <div class="upgrade-current-row">
                        <div class="upgrade-current-left">
                            <span class="upgrade-current-label">Current Level</span>
                            <span class="tier-badge tier-badge-<?php echo $userTier; ?> tier-badge-lg">TIER <?php echo $userTier; ?></span>
                        </div>
                        <div class="upgrade-current-right">
                            <span class="upgrade-current-label">Daily Limit</span>
                            <span class="upgrade-current-value">KSh 70,000</span>
                        </div>
                    </div>
                </div>

                <div class="upgrade-tiers-grid">

                    <div class="upgrade-tier-card card upgrade-tier-active">
                        <div class="upgrade-tier-header">
                            <span class="tier-badge tier-badge-1">TIER 1</span>
                            <span class="upgrade-tier-status upgrade-tier-status-current">Current</span>
                        </div>
                        <h3 class="upgrade-tier-name">Basic</h3>
                        <p class="upgrade-tier-desc">Standard account with basic verification</p>
                        <div class="upgrade-tier-limits">
                            <div class="upgrade-limit-row">
                                <span class="upgrade-limit-label">Daily send limit</span>
                                <span class="upgrade-limit-value">KSh 70,000</span>
                            </div>
                            <div class="upgrade-limit-row">
                                <span class="upgrade-limit-label">Monthly limit</span>
                                <span class="upgrade-limit-value">KSh 300,000</span>
                            </div>
                            <div class="upgrade-limit-row">
                                <span class="upgrade-limit-label">Max per transaction</span>
                                <span class="upgrade-limit-value">KSh 35,000</span>
                            </div>
                        </div>
                        <div class="upgrade-tier-reqs">
                            <span class="upgrade-reqs-title">Requirements</span>
                            <div class="upgrade-req-item upgrade-req-done">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><polyline points="20 6 9 17 4 12"/></svg>
                                <span>Phone number verified</span>
                            </div>
                            <div class="upgrade-req-item upgrade-req-done">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><polyline points="20 6 9 17 4 12"/></svg>
                                <span>Email verified</span>
                            </div>
                        </div>
                    </div>

                    <div class="upgrade-tier-card card upgrade-tier-next">
                        <div class="upgrade-tier-header">
                            <span class="tier-badge tier-badge-2">TIER 2</span>
                            <span class="upgrade-tier-status upgrade-tier-status-next">Next Level</span>
                        </div>
                        <h3 class="upgrade-tier-name">Verified</h3>
                        <p class="upgrade-tier-desc">Enhanced limits with identity verification</p>
                        <div class="upgrade-tier-limits">
                            <div class="upgrade-limit-row">
                                <span class="upgrade-limit-label">Daily send limit</span>
                                <span class="upgrade-limit-value">KSh 300,000</span>
                            </div>
                            <div class="upgrade-limit-row">
                                <span class="upgrade-limit-label">Monthly limit</span>
                                <span class="upgrade-limit-value">KSh 1,500,000</span>
                            </div>
                            <div class="upgrade-limit-row">
                                <span class="upgrade-limit-label">Max per transaction</span>
                                <span class="upgrade-limit-value">KSh 150,000</span>
                            </div>
                        </div>
                        <div class="upgrade-tier-reqs">
                            <span class="upgrade-reqs-title">Requirements</span>
                            <div class="upgrade-req-item upgrade-req-pending">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/></svg>
                                <span>Government-issued ID</span>
                            </div>
                            <div class="upgrade-req-item upgrade-req-pending">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/></svg>
                                <span>Selfie verification</span>
                            </div>
                            <div class="upgrade-req-item upgrade-req-pending">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/></svg>
                                <span>Proof of address</span>
                            </div>
                        </div>
                        <button class="btn btn-primary ke-proceed-btn upgrade-cta" data-demo>Upgrade to Tier 2</button>
                    </div>

                    <div class="upgrade-tier-card card upgrade-tier-locked">
                        <div class="upgrade-tier-header">
                            <span class="tier-badge tier-badge-3">TIER 3</span>
                            <span class="upgrade-tier-status upgrade-tier-status-locked">Locked</span>
                        </div>
                        <h3 class="upgrade-tier-name">Premium</h3>
                        <p class="upgrade-tier-desc">Maximum limits for business and high-volume users</p>
                        <div class="upgrade-tier-limits">
                            <div class="upgrade-limit-row">
                                <span class="upgrade-limit-label">Daily send limit</span>
                                <span class="upgrade-limit-value">KSh 1,000,000</span>
                            </div>
                            <div class="upgrade-limit-row">
                                <span class="upgrade-limit-label">Monthly limit</span>
                                <span class="upgrade-limit-value">KSh 5,000,000</span>
                            </div>
                            <div class="upgrade-limit-row">
                                <span class="upgrade-limit-label">Max per transaction</span>
                                <span class="upgrade-limit-value">KSh 500,000</span>
                            </div>
                        </div>
                        <div class="upgrade-tier-reqs">
                            <span class="upgrade-reqs-title">Requirements</span>
                            <div class="upgrade-req-item upgrade-req-locked">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0 1 10 0v4"/></svg>
                                <span>Complete Tier 2 first</span>
                            </div>
                            <div class="upgrade-req-item upgrade-req-locked">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0 1 10 0v4"/></svg>
                                <span>Business documentation</span>
                            </div>
                            <div class="upgrade-req-item upgrade-req-locked">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0 1 10 0v4"/></svg>
                                <span>Enhanced due diligence</span>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="upgrade-back">
                    <a href="profile.php" class="country-back-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"/></svg>
                        Back to profile
                    </a>
                </div>

            </div>

        </main>
        <?php include 'partials/footer.php'; ?>
    </div>
</div>
